import React from 'react';
import { AppNameIcon } from './icons/AppNameIcon';

interface AppNameInputProps {
  value: string;
  onChange: (value: string) => void;
}

export const AppNameInput: React.FC<AppNameInputProps> = ({ value, onChange }) => {
  return (
    <div>
      <label htmlFor="app-name" className="block text-sm font-medium text-slate-300 mb-2">
        Step 2: Enter Your Application Name
      </label>
      <div className="relative">
        <div className="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
          <AppNameIcon className="h-5 w-5 text-slate-400" />
        </div>
        <input
          type="text"
          id="app-name"
          value={value}
          onChange={(e) => onChange(e.target.value)}
          className="bg-slate-900/50 border border-slate-700 text-white placeholder-slate-500 text-sm rounded-lg focus:ring-indigo-500 focus:border-indigo-500 block w-full pl-10 p-3 transition-colors duration-200"
          placeholder="My Awesome App"
          required
        />
      </div>
    </div>
  );
};