
import React from 'react';
import { AndroidIcon } from './icons/AndroidIcon';

export const Header: React.FC = () => {
    return (
        <header className="text-center">
            <div className="inline-block bg-slate-800 p-4 rounded-full mb-4 border-2 border-slate-700 shadow-lg">
                 <AndroidIcon className="w-12 h-12 text-green-400" />
            </div>
            <h1 className="text-4xl sm:text-5xl font-extrabold text-transparent bg-clip-text bg-gradient-to-r from-green-300 via-blue-400 to-indigo-500">
                Android App Builder
            </h1>
            <p className="mt-4 text-lg text-slate-400 max-w-xl mx-auto">
                Instantly generate the project files for an Android app that showcases your website.
            </p>
      </header>
    );
}
