import React from 'react';
import { ImageIcon } from './icons/ImageIcon';

interface ImageUploaderProps {
  onImageUpload: (file: File) => void;
  imageUrl: string;
}

export const ImageUploader: React.FC<ImageUploaderProps> = ({ onImageUpload, imageUrl }) => {
  const handleFileChange = (event: React.ChangeEvent<HTMLInputElement>) => {
    if (event.target.files && event.target.files[0]) {
      onImageUpload(event.target.files[0]);
    }
  };

  return (
    <div>
      <label className="block text-sm font-medium text-slate-300 mb-2">
        Step 3: Upload Your Splash Screen Image
      </label>
      <div className="mt-2 flex items-center gap-4">
        {imageUrl ? (
            <img src={imageUrl} alt="Splash screen preview" className="w-20 h-20 rounded-lg object-cover border-2 border-slate-600" />
        ) : (
            <div className="w-20 h-20 bg-slate-900/50 rounded-lg flex items-center justify-center border-2 border-slate-700">
                <ImageIcon className="w-8 h-8 text-slate-500" />
            </div>
        )}
        <label htmlFor="file-upload" className="relative cursor-pointer bg-slate-700 rounded-md font-medium text-indigo-400 hover:text-indigo-300 focus-within:outline-none focus-within:ring-2 focus-within:ring-offset-2 focus-within:ring-offset-slate-800 focus-within:ring-indigo-500 px-4 py-2 transition-colors">
          <span>{imageUrl ? 'Change image' : 'Upload an image'}</span>
          <input id="file-upload" name="file-upload" type="file" className="sr-only" accept="image/png, image/jpeg" onChange={handleFileChange} />
        </label>
      </div>
       <p className="text-xs text-slate-500 mt-2">PNG or JPG. Recommended size: 1080x1920px.</p>
    </div>
  );
};